<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* default/template/common/cart.twig */
class __TwigTemplate_e087ceebce03c2e4480df2f6b1c63d33 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<div id=\"cart\" class=\"btn-group btn-block mini-cart\">
  <button type=\"button\" data-toggle=\"dropdown\" data-loading-text=\"";
        // line 2
        echo ($context["text_loading"] ?? null);
        echo "\" class=\"mini-cart-toggle dropdown-toggle\">
    <span class=\"mini-cart-total\">";
        // line 3
        echo ((($context["cart_total_value"] ?? null)) ?: (($context["text_items"] ?? null)));
        echo "</span>
    <span class=\"mini-cart-icon\">
      <i class=\"fa fa-shopping-cart\" aria-hidden=\"true\"></i>
      <span class=\"mini-cart-count\">";
        // line 6
        echo ($context["item_count"] ?? null);
        echo "</span>
    </span>
    <span id=\"cart-total\" class=\"sr-only\">";
        // line 8
        echo ($context["text_items"] ?? null);
        echo "</span>
    
  </button>
  <ul class=\"dropdown-menu pull-right mini-cart-dropdown\">
    ";
        // line 12
        if ((($context["products"] ?? null) || ($context["vouchers"] ?? null))) {
            // line 13
            echo "    <li>
      <table class=\"table table-striped\">
        ";
            // line 15
            $context['_parent'] = $context;
            $context['_seq'] = twig_ensure_traversable(($context["products"] ?? null));
            foreach ($context['_seq'] as $context["_key"] => $context["product"]) {
                // line 16
                echo "        <tr>
          <td class=\"text-center\">";
                // line 17
                if (twig_get_attribute($this->env, $this->source, $context["product"], "thumb", [], "any", false, false, false, 17)) {
                    echo " <a href=\"";
                    echo twig_get_attribute($this->env, $this->source, $context["product"], "href", [], "any", false, false, false, 17);
                    echo "\"><img src=\"";
                    echo twig_get_attribute($this->env, $this->source, $context["product"], "thumb", [], "any", false, false, false, 17);
                    echo "\" alt=\"";
                    echo twig_get_attribute($this->env, $this->source, $context["product"], "name", [], "any", false, false, false, 17);
                    echo "\" title=\"";
                    echo twig_get_attribute($this->env, $this->source, $context["product"], "name", [], "any", false, false, false, 17);
                    echo "\" class=\"img-thumbnail\" /></a> ";
                }
                echo "</td>
          <td class=\"text-left\"><a href=\"";
                // line 18
                echo twig_get_attribute($this->env, $this->source, $context["product"], "href", [], "any", false, false, false, 18);
                echo "\">";
                echo twig_get_attribute($this->env, $this->source, $context["product"], "name", [], "any", false, false, false, 18);
                echo "</a> ";
                if (twig_get_attribute($this->env, $this->source, $context["product"], "option", [], "any", false, false, false, 18)) {
                    // line 19
                    echo "            ";
                    $context['_parent'] = $context;
                    $context['_seq'] = twig_ensure_traversable(twig_get_attribute($this->env, $this->source, $context["product"], "option", [], "any", false, false, false, 19));
                    foreach ($context['_seq'] as $context["_key"] => $context["option"]) {
                        echo " <br />
            - <small>";
                        // line 20
                        echo twig_get_attribute($this->env, $this->source, $context["option"], "name", [], "any", false, false, false, 20);
                        echo " ";
                        echo twig_get_attribute($this->env, $this->source, $context["option"], "value", [], "any", false, false, false, 20);
                        echo "</small> ";
                    }
                    $_parent = $context['_parent'];
                    unset($context['_seq'], $context['_iterated'], $context['_key'], $context['option'], $context['_parent'], $context['loop']);
                    $context = array_intersect_key($context, $_parent) + $_parent;
                    // line 21
                    echo "            ";
                }
                // line 22
                echo "            ";
                if (twig_get_attribute($this->env, $this->source, $context["product"], "recurring", [], "any", false, false, false, 22)) {
                    echo " <br />
            - <small>";
                    // line 23
                    echo ($context["text_recurring"] ?? null);
                    echo " ";
                    echo twig_get_attribute($this->env, $this->source, $context["product"], "recurring", [], "any", false, false, false, 23);
                    echo "</small> ";
                }
                echo "</td>
          <td class=\"text-right\">x ";
                // line 24
                echo twig_get_attribute($this->env, $this->source, $context["product"], "quantity", [], "any", false, false, false, 24);
                echo "</td>
          <td class=\"text-right\">";
                // line 25
                echo twig_get_attribute($this->env, $this->source, $context["product"], "total", [], "any", false, false, false, 25);
                echo "</td>
          <td class=\"text-center\"><button type=\"button\" onclick=\"cart.remove('";
                // line 26
                echo twig_get_attribute($this->env, $this->source, $context["product"], "cart_id", [], "any", false, false, false, 26);
                echo "');\" title=\"";
                echo ($context["button_remove"] ?? null);
                echo "\" class=\"btn btn-remove-cart  btn-xs\"><i class=\"fa fa-times\"></i></button></td>
        </tr>
        ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_iterated'], $context['_key'], $context['product'], $context['_parent'], $context['loop']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 29
            echo "        ";
            $context['_parent'] = $context;
            $context['_seq'] = twig_ensure_traversable(($context["vouchers"] ?? null));
            foreach ($context['_seq'] as $context["_key"] => $context["voucher"]) {
                // line 30
                echo "        <tr>
          <td class=\"text-center\"></td>
          <td class=\"text-left\">";
                // line 32
                echo twig_get_attribute($this->env, $this->source, $context["voucher"], "description", [], "any", false, false, false, 32);
                echo "</td>
          <td class=\"text-right\">x&nbsp;1</td>
          <td class=\"text-right\">";
                // line 34
                echo twig_get_attribute($this->env, $this->source, $context["voucher"], "amount", [], "any", false, false, false, 34);
                echo "</td>
          <td class=\"text-center text-danger\"><button type=\"button\" onclick=\"voucher.remove('";
                // line 35
                echo twig_get_attribute($this->env, $this->source, $context["voucher"], "key", [], "any", false, false, false, 35);
                echo "');\" title=\"";
                echo ($context["button_remove"] ?? null);
                echo "\" class=\"btn btn-danger btn-xs\"><i class=\"fa fa-times\"></i></button></td>
        </tr>
        ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_iterated'], $context['_key'], $context['voucher'], $context['_parent'], $context['loop']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 38
            echo "      </table>
    </li>
    <li>
      <div>
        <table class=\"table \">
          ";
            // line 43
            $context['_parent'] = $context;
            $context['_seq'] = twig_ensure_traversable(($context["totals"] ?? null));
            foreach ($context['_seq'] as $context["_key"] => $context["total"]) {
                // line 44
                echo "          <tr>
            <td class=\"text-right\"><strong>";
                // line 45
                echo twig_get_attribute($this->env, $this->source, $context["total"], "title", [], "any", false, false, false, 45);
                echo "</strong></td>
            <td class=\"text-right\">";
                // line 46
                echo twig_get_attribute($this->env, $this->source, $context["total"], "text", [], "any", false, false, false, 46);
                echo "</td>
          </tr>
          ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_iterated'], $context['_key'], $context['total'], $context['_parent'], $context['loop']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 49
            echo "        </table>
        <p class=\"text-right\"><a href=\"";
            // line 50
            echo ($context["cart"] ?? null);
            echo "\" class=\"cus-btn\"><strong><i class=\"fa fa-shopping-cart\"></i> ";
            echo ($context["text_cart"] ?? null);
            echo "</strong></a>&nbsp;&nbsp;&nbsp;<a href=\"";
            echo ($context["checkout"] ?? null);
            echo "\" class=\"cus-btn\"><strong><i class=\"fa fa-share\"></i> ";
            echo ($context["text_checkout"] ?? null);
            echo "</strong></a></p>
      </div>
    </li>
    ";
        } else {
            // line 54
            echo "    <li>
      <p class=\"text-center\">";
            // line 55
            echo ($context["text_empty"] ?? null);
            echo "</p>
    </li>
    ";
        }
        // line 58
        echo "  </ul>
</div>


<script>
(function(\$) {
  function parseCartSummary(summary) {
    var countMatch = summary ? summary.match(/(\\d+)/) : null;
    var totalText = summary || '';

    if (summary) {
      var separators = [' - ', ' – ', '- ', ' -', '-'];

      for (var i = 0; i < separators.length; i++) {
        var sep = separators[i];
        var idx = summary.lastIndexOf(sep);

        if (idx !== -1) {
          totalText = summary.substring(idx + sep.length).trim();
          break;
        }
      }
    }

    return {
      summary: summary || '',
      count: countMatch ? countMatch[1] : '0',
      total: totalText
    };
  }

  function renderMiniCart(summary) {
    var \$button = \$('#cart').find('.mini-cart-toggle');

    if (!\$button.length) {
      return;
    }

    var parsed = parseCartSummary(summary || \$('#cart-total').text());
    var totalText = parsed.total || parsed.summary;

    var template = '' +
      '<span class=\"mini-cart-total\">' + totalText + '</span>' +
      '<span class=\"mini-cart-icon\">' +
        '<i class=\"fa fa-shopping-cart\" aria-hidden=\"true\"></i>' +
        '<span class=\"mini-cart-count\">' + parsed.count + '</span>' +
      '</span>' +
      '<span id=\"cart-total\" class=\"sr-only\">' + parsed.summary + '</span>';

    \$button.html(template);
  }

  \$(document).ready(function() {
    renderMiniCart(\$('#cart-total').text());
  });

  \$(document).ajaxSuccess(function(event, xhr, settings, data) {
    if (!settings || !settings.url) {
      return;
    }

    if (settings.url.indexOf('checkout/cart/') === -1) {
      return;
    }

    var response = data || (xhr && xhr.responseJSON) || null;

    if (response && response.total) {
      renderMiniCart(response.total);
    }
  });
})(window.jQuery);
</script>
";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName()
    {
        return "default/template/common/cart.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable()
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo()
    {
        return array (  227 => 58,  221 => 55,  218 => 54,  205 => 50,  202 => 49,  193 => 46,  189 => 45,  186 => 44,  182 => 43,  175 => 38,  164 => 35,  160 => 34,  155 => 32,  151 => 30,  146 => 29,  135 => 26,  131 => 25,  127 => 24,  119 => 23,  114 => 22,  111 => 21,  102 => 20,  95 => 19,  89 => 18,  75 => 17,  72 => 16,  68 => 15,  64 => 13,  62 => 12,  55 => 8,  50 => 6,  44 => 3,  40 => 2,  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "default/template/common/cart.twig", "");
    }
}
