<?php
class ControllerExtensionModuleTopbar extends Controller {
  public function index($setting = []) {
    if (!$setting) {
      $saved = $this->config->get('module_topbar_setting');
      if (is_array($saved)) {
        $setting = $saved;
      }
    }

    $setting = array_merge([
      'information_ids' => [],
      'show_catalog'    => false,
      'catalog_title'   => [],
      'show_language'   => false,
      'show_currency'   => false,
      'show_worktime'   => false,
      'worktime_title'  => [],
      'worktime_items'  => [],
      'show_client'     => false,
      'client_title'    => [],
      'client_items'    => []
    ], is_array($setting) ? $setting : []);

    $this->load->model('catalog/information');

    // 1) Информационные страницы слева (заданы в настройках модуля)
    $data['left_links'] = [];
    $info_ids = $setting['information_ids'] ?? [];
    foreach ($info_ids as $id) {
      $info = $this->model_catalog_information->getInformation((int)$id);
      if ($info) {
        $data['left_links'][] = [
          'title' => $info['title'],
          'href'  => $this->url->link('information/information', 'information_id=' . (int)$id)
        ];
      }
    }
    // «Каталог» — специальная ссылка на список категорий
    if (!empty($setting['show_catalog'])) {
      $data['left_links'][] = [
        'title' => $this->getLocalizedValue($setting['catalog_title'], $this->config->get('config_language_id'), 'Каталог'),
        'href'  => $this->url->link('product/category')
      ];
    }

    // 2) Встроенные контроллеры OpenCart
    $data['language'] = !empty($setting['show_language']) ? $this->load->controller('common/language') : '';
    $data['currency'] = !empty($setting['show_currency']) ? $this->load->controller('common/currency') : '';

    // 3) Правые дропдауны
    $lang_id = $this->config->get('config_language_id');
    $data['worktime'] = [
      'title' => $this->getLocalizedValue($setting['worktime_title'], $lang_id, 'Время работы'),
      'items' => $this->getLocalizedList($setting['worktime_items'], $lang_id)
    ];
    $data['client'] = [
      'title' => $this->getLocalizedValue($setting['client_title'], $lang_id, 'Клиент-центр'),
      'items' => $this->getLocalizedList($setting['client_items'], $lang_id)
    ];
    $data['show_worktime'] = !empty($setting['show_worktime']);
    $data['show_client']   = !empty($setting['show_client']);

    return $this->load->view('extension/module/topbar', $data);
  }

  private function getLocalizedValue($values, $language_id, $default = '') {
    if (is_array($values)) {
      if (!empty($values[$language_id])) {
        return $values[$language_id];
      }

      $first = reset($values);

      if (is_string($first) && $first !== '') {
        return $first;
      }
    }

    return $default;
  }

  private function getLocalizedList($lists, $language_id) {
    if (is_array($lists)) {
      if (!empty($lists[$language_id]) && is_array($lists[$language_id])) {
        return $lists[$language_id];
      }

      foreach ($lists as $items) {
        if (is_array($items) && $items) {
          return $items;
        }
      }
    }

    return [];
  }
}

