<?php
class ControllerExtensionModuleCategoryCards extends Controller {
	public function index($setting) {
		$this->load->language('extension/module/category_cards');

		$this->load->model('catalog/category');
		$this->load->model('tool/image');

		$data['heading_title'] = !empty($setting['title']) ? $setting['title'] : $this->language->get('heading_title');
		$data['categories'] = array();

		$width = !empty($setting['width']) ? (int)$setting['width'] : 600;
		$height = !empty($setting['height']) ? (int)$setting['height'] : 350;

		if (!empty($setting['category_ids']) && is_array($setting['category_ids'])) {
			foreach ($setting['category_ids'] as $category_id) {
				$category_info = $this->model_catalog_category->getCategory($category_id);

				if ($category_info) {
					$image = $category_info['image'] ? $this->model_tool_image->resize($category_info['image'], $width, $height) : $this->model_tool_image->resize('placeholder.png', $width, $height);

					$data['categories'][] = array(
						'name' => $category_info['name'],
						'thumb' => $image,
						'href' => $this->url->link('product/category', 'path=' . $category_id)
					);
				}
			}
		}

		if (!$data['categories']) {
			return '';
		}

		return $this->load->view('extension/module/category_cards', $data);
	}
}
