<?php
class ControllerExtensionModuleAboutBlock extends Controller {
	public function index($setting) {
		$this->load->model('tool/image');

		$language_id = (int)$this->config->get('config_language_id');

		$title = $setting['title'][$language_id] ?? '';
		$subtitle = $setting['subtitle'][$language_id] ?? '';

		$description = '';

		if (!empty($setting['description'][$language_id])) {
			$description = html_entity_decode($setting['description'][$language_id], ENT_QUOTES, 'UTF-8');
			$description = nl2br($description);
		}

		$button_text = $setting['button_text'][$language_id] ?? '';
		$button_link = $setting['button_link'] ?? '';

		$image = '';

		if (!empty($setting['image']) && is_file(DIR_IMAGE . $setting['image'])) {
			$image = $this->model_tool_image->resize($setting['image'], 220, 220);
		}

		if (!$title && !$subtitle && !$description && !$image) {
			return;
		}
		

		$data['title'] = $title;
		$data['subtitle'] = $subtitle;
		$data['description'] = $description;
		$data['button_text'] = $button_text;
		$data['button_link'] = $button_link;
		$data['image'] = $image;

		return $this->load->view('extension/module/about_block', $data);
	}
}
