<?php
class ControllerCommonSearch extends Controller {
	public function index() {
		$this->load->language('common/search');
		$this->load->language('common/language');

		$data['text_search'] = $this->language->get('text_search');
		$data['text_all_categories'] = $this->language->get('text_all_categories');

		if (!$data['text_all_categories'] || $data['text_all_categories'] === 'text_all_categories') {
			$data['text_all_categories'] = 'All Categories';
		}

		if (isset($this->request->get['search'])) {
			$data['search'] = $this->request->get['search'];
		} else {
			$data['search'] = '';
		}
    


		$data['category_id'] = isset($this->request->get['category_id']) ? (int)$this->request->get['category_id'] : 0;
		$data['categories'] = $this->getCategoryTree();
		$data['selected_category_name'] = $this->resolveCategoryName($data['categories'], $data['category_id'], $data['text_all_categories']);

		$data['search_action'] = $this->url->link('product/search');
		$data['sub_category_value'] = 'true';

		return $this->load->view('common/search', $data);
	}

	private function getCategoryTree($parent_id = 0) {
		$language_id = (int)$this->config->get('config_language_id');
		$store_id = (int)$this->config->get('config_store_id');

		$sql = "SELECT c.category_id, cd.name FROM " . DB_PREFIX . "category c LEFT JOIN " . DB_PREFIX . "category_description cd ON (c.category_id = cd.category_id) LEFT JOIN " . DB_PREFIX . "category_to_store c2s ON (c.category_id = c2s.category_id) WHERE c.parent_id = '" . (int)$parent_id . "' AND c.status = '1' AND cd.language_id = '" . $language_id . "' AND c2s.store_id = '" . $store_id . "' ORDER BY c.sort_order, LCASE(cd.name)";

		$query = $this->db->query($sql);

		$categories = array();

		foreach ($query->rows as $row) {
			$categories[] = array(
				'category_id' => (int)$row['category_id'],
				'name'        => $row['name'],
				'children'    => $this->getCategoryTree($row['category_id'])
			);
		}

		return $categories;
	}

	private function resolveCategoryName(array $categories, $category_id, $default) {
		$name = $this->findCategoryName($categories, $category_id);

		if ($name === null || $name === '') {
			return $default;
		}

		return $name;
	}

	private function findCategoryName(array $categories, $category_id) {
		foreach ($categories as $category) {
			if ((int)$category['category_id'] === (int)$category_id) {
				return $category['name'];
			}

			if (!empty($category['children'])) {
				$name = $this->findCategoryName($category['children'], $category_id);

				if ($name !== null) {
					return $name;
				}
			}
		}

		return null;
	}
}
