<?php
class ControllerCommonMenu extends Controller {
	public function index() {
		$this->load->language('common/menu');

		// Menu
		$this->load->model('catalog/category');
		$this->load->model('catalog/product');
		$this->load->model('tool/image');

		$data['mega_menu'] = array(
			'title' => 'Категории товаров',
			'items' => array()
		);

		$categories = $this->model_catalog_category->getCategories(0);
    

		foreach ($categories as $category) {
			if (!$category['top']) {
				continue;
			}

			$image_path = !empty($category['image']) ? $category['image'] : 'placeholder.png';

			$data['mega_menu']['items'][] = array(
				'name'  => $category['name'],
				'image' => $this->model_tool_image->resize($image_path, 220, 140),
				'href'  => $this->url->link('product/category', 'path=' . $category['category_id'])
			);
		}

		$data['static_links'] = array(
			array('title' => 'Видео', 'href' => $this->url->link('product/category')),
			array('title' => 'Статьи', 'href' => $this->url->link('information/information')),
			array('title' => 'Свяжитесь с нами', 'href' => $this->url->link('information/contact')),
			array('title' => 'Полезная информация', 'href' => $this->url->link('information/information')),
			array('title' => 'Станьте дистрибьютором', 'href' => $this->url->link('information/contact')),
			array('title' => 'Конфигуратор линии', 'href' => $this->url->link('product/category')),
			array('title' => 'Отзывы', 'href' => $this->url->link('information/information')),
			array('title' => 'Наши награды', 'href' => $this->url->link('information/information'))
		);

		return $this->load->view('common/menu', $data);
	}
}
