<?php
class ControllerCommonLanguage extends Controller {
	public function index() {
		$this->load->language('common/language');

		$data['text_language'] = $this->language->get('text_language');
		$data['action'] = $this->url->link('common/language/language', '', true);

		if (isset($this->session->data['language'])) {
			$data['language_code'] = $this->session->data['language'];
		} else {
			$data['language_code'] = $this->config->get('config_language');
		}

		// Build redirect url so language switch keeps the current page
		if (!isset($this->request->get['route'])) {
			$data['redirect'] = $this->url->link('common/home');
		} else {
			$route = $this->request->get['route'];
			$url_data = $this->request->get;

			
			unset($url_data['_route_']);
			unset($url_data['route']);

			$url = '';

			if ($url_data) {
				$url = http_build_query($url_data);
			}

			$data['redirect'] = $this->url->link($route, $url, true);
		}

		
		$data['languages'] = array();

		$languages = $this->getLanguages();

		foreach ($languages as $language) {
			if (!empty($language['status'])) {
				$data['languages'][] = array(
					'name'  => $language['name'],
					'code'  => $language['code'],
					'image' => 'catalog/language/' . $language['code'] . '/' . $language['code'] . '.png'
				);
			}
		}

		if (count($data['languages']) < 2) {
			return '';
		}

		return $this->load->view('common/language', $data);
	}

	public function language() {
		if (isset($this->request->post['code'])) {
			$this->session->data['language'] = $this->request->post['code'];
		}

		if (isset($this->request->post['redirect'])) {
			$this->response->redirect($this->request->post['redirect']);
		} else {
			$this->response->redirect($this->url->link('common/home'));
		}
	}

	protected function getLanguages() {
		$language_data = $this->cache->get('language.catalog');

		if (!$language_data) {
			$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "language` ORDER BY sort_order, name");
			$language_data = $query->rows;

			$this->cache->set('language.catalog', $language_data);
		}

		return $language_data;
	}
}
