<?php
class ControllerCommonFooter extends Controller {
	public function index() {
		$this->load->language('common/footer');

		$this->load->model('catalog/information');

		$data['informations'] = array();

		foreach ($this->model_catalog_information->getInformations() as $result) {
			if ($result['bottom']) {
				$data['informations'][] = array(
					'title' => $result['title'],
					'href'  => $this->url->link('information/information', 'information_id=' . $result['information_id'])
				);
			}
		}

		$data['contact'] = $this->url->link('information/contact');
		$data['return'] = $this->url->link('account/return/add', '', true);
		$data['sitemap'] = $this->url->link('information/sitemap');
		$data['tracking'] = $this->url->link('information/tracking');
		$data['manufacturer'] = $this->url->link('product/manufacturer');
		$data['voucher'] = $this->url->link('account/voucher', '', true);
		$data['affiliate'] = $this->url->link('affiliate/login', '', true);
		$data['special'] = $this->url->link('product/special');
		$data['account'] = $this->url->link('account/account', '', true);
		$data['order'] = $this->url->link('account/order', '', true);
		$data['wishlist'] = $this->url->link('account/wishlist', '', true);
		$data['newsletter'] = $this->url->link('account/newsletter', '', true);

		$telephone = $this->config->get('config_telephone');
		$email = $this->config->get('config_email');
		$address = $this->config->get('config_address');

		$telephone_href = preg_replace('/[^0-9+]/', '', $telephone);

    
		if ($telephone_href && substr($telephone_href, 0, 1) !== '+') {
			$telephone_href = '+' . $telephone_href;
		}

		$data['footer_features'] = array(
			array(
				'icon' => 'fa-phone',
				'title' => $this->language->get('text_hotline'),
				'description' => $this->language->get('text_hotline_desc')
			),
			array(
				'icon' => 'fa-star',
				'title' => $this->language->get('text_guarantee'),
				'description' => $this->language->get('text_guarantee_desc')
			),
			array(
				'icon' => 'fa-truck',
				'title' => $this->language->get('text_delivery'),
				'description' => $this->language->get('text_delivery_desc')
			),
			array(
				'icon' => 'fa-users',
				'title' => $this->language->get('text_partner'),
				'description' => $this->language->get('text_partner_desc')
			)
		);

		$data['footer_contacts'] = array(
			array(
				'icon' => 'fa-map-marker',
				'text' => nl2br($address),
				'href' => $this->url->link('information/contact'),
				'is_html' => true
			),
			array(
				'icon' => 'fa-phone',
				'text' => $telephone,
				'href' => $telephone_href ? 'tel:' . $telephone_href : ''
			),
			array(
				'icon' => 'fa-envelope',
				'text' => $email,
				'href' => $email ? 'mailto:' . $email : ''
			),
			array(
				'icon' => 'fa-clock-o',
				'text' => $this->language->get('text_schedule')
			),
			array(
				'icon' => 'fa-calendar-times-o',
				'text' => $this->language->get('text_weekend')
			)
		);

		$socials_config = array(
			'facebook' => 'fa-facebook',
			'instagram' => 'fa-instagram',
			'youtube' => 'fa-youtube-play',
			'telegram' => 'fa-telegram',
			'whatsapp' => 'fa-whatsapp'
		);

		$data['footer_socials'] = array();

		foreach ($socials_config as $key => $icon) {
			$link = $this->config->get('config_' . $key);

			if (!$link) {
				$link = '#';
			}

			$data['footer_socials'][] = array(
				'icon' => $icon,
				'href' => $link
			);
		}

		$data['text_subscribe'] = $this->language->get('text_subscribe');
		$data['text_subscribe_placeholder'] = $this->language->get('text_subscribe_placeholder');
		$data['text_subscribe_button'] = $this->language->get('text_subscribe_button');
		$data['text_follow_us'] = $this->language->get('text_follow_us');
		$data['text_contacts'] = $this->language->get('text_contacts');

		$data['subscribe_action'] = '#';

		$data['powered'] = sprintf($this->language->get('text_powered'), $this->config->get('config_name'), date('Y'));

		// Whos Online
		if ($this->config->get('config_customer_online')) {
			$this->load->model('tool/online');

			if (isset($this->request->server['REMOTE_ADDR'])) {
				$ip = $this->request->server['REMOTE_ADDR'];
			} else {
				$ip = '';
			}

			if (isset($this->request->server['HTTP_HOST']) && isset($this->request->server['REQUEST_URI'])) {
				$url = ($this->request->server['HTTPS'] ? 'https://' : 'http://') . $this->request->server['HTTP_HOST'] . $this->request->server['REQUEST_URI'];
			} else {
				$url = '';
			}

			if (isset($this->request->server['HTTP_REFERER'])) {
				$referer = $this->request->server['HTTP_REFERER'];
			} else {
				$referer = '';
			}

			$this->model_tool_online->addOnline($ip, $this->customer->getId(), $url, $referer);
		}

		$data['scripts'] = $this->document->getScripts('footer');
		$data['styles'] = $this->document->getStyles('footer');
		
		return $this->load->view('common/footer', $data);
	}
}
