<?php
/******************************************************************************
 * Copyright (C) 2019-2023 P. Mergey
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/#GPL>.
 *****************************************************************************/
// Heading
$_['heading_title'] = 'Paramètres';
// Text
$_['text_stores'] = 'Boutiques';
$_['text_success'] = 'Les paramètres ont été modifiés avec succès !';
$_['text_edit'] = 'Modifier les paramètres';
$_['text_product'] = 'Produits';
$_['text_review'] = 'Évaluations';
$_['text_voucher'] = 'Bons d’achat';
$_['text_tax'] = 'Taxes';
$_['text_account'] = 'Compte';
$_['text_checkout'] = 'Valider la commande';
$_['text_stock'] = 'Stock';
$_['text_affiliate'] = 'Affiliés';
$_['text_captcha'] = 'CAPTCHA';
$_['text_register'] = 'Inscription';
$_['text_guest'] = 'Commander sans s’enregistrer';
$_['text_return'] = 'Retours';
$_['text_contact'] = 'Contact';
$_['text_shipping'] = 'Adresse de livraison';
$_['text_payment'] = 'Adresse de facturation';
$_['text_mail'] = 'Mail';
$_['text_smtp'] = 'SMTP';
$_['text_mail_alert'] = 'Alerte par courrier électronique';
$_['text_mail_account'] = 'S’inscrire';
$_['text_mail_affiliate'] = 'Affilié';
$_['text_mail_order'] = 'Commandes';
$_['text_mail_review'] = 'Évaluations';
$_['text_general'] = 'Général';
$_['text_security'] = 'Sécurité';
$_['text_upload'] = 'Transferts de fichiers';
$_['text_error'] = 'Gestion des erreurs';
// Entry
$_['entry_meta_title'] = 'Titre du métaélément';
$_['entry_meta_description'] = 'Description du métaélément';
$_['entry_meta_keyword'] = 'Mots-clefs du métaélément';
$_['entry_layout'] = 'Gabarit par défault';
$_['entry_theme'] = 'Thème';
$_['entry_name'] = 'Nom de la boutique';
$_['entry_owner'] = 'Propriétaire de la boutique';
$_['entry_address'] = 'Adresse';
$_['entry_geocode'] = 'Géocode';
$_['entry_email'] = 'Adresse électronique';
$_['entry_telephone'] = 'Numéro de téléphone';
$_['entry_fax'] = 'Numéro de télécopie';
$_['entry_image'] = 'Image';
$_['entry_open'] = 'Horaires d’ouverture';
$_['entry_comment'] = 'Commentaire';
$_['entry_location'] = 'Emplacement de la boutique';
$_['entry_country'] = 'Pays';
$_['entry_zone'] = 'Subdivision administrative';
$_['entry_timezone'] = 'Fuseau horaire';
$_['entry_language'] = 'Langue';
$_['entry_admin_language'] = 'Langue d’administration';
$_['entry_currency'] = 'Devise';
$_['entry_currency_auto'] = 'Mise à jour automatique des devises';
$_['entry_length_class'] = 'Unité de longueur';
$_['entry_weight_class'] = 'Unité de poids';
$_['entry_limit_admin'] = 'Nombre d’éléments par page par défaut (administration)';
$_['entry_product_count'] = 'Comptabilisation de produit';
$_['entry_review'] = 'Autoriser les évaluations';
$_['entry_review_guest'] = 'Autoriser les évaluation des visiteurs';
$_['entry_voucher_min'] = 'Bon d’achat minimum';
$_['entry_voucher_max'] = 'Bon d’achat maximum';
$_['entry_tax'] = 'Afficher les prix avec les taxes';
$_['entry_tax_default'] = 'Utiliser les taxes en fonction de l’adresse de la boutique';
$_['entry_tax_customer'] = 'Utiliser les taxes en fonction de l’adresse du client';
$_['entry_customer_online'] = 'Visiteurs en ligne';
$_['entry_customer_activity'] = 'Activité des clients';
$_['entry_customer_search'] = 'Journal des recherche de client';
$_['entry_customer_group'] = 'Groupe de clients';
$_['entry_customer_group_display'] = 'Affichage des groupes de clients';
$_['entry_customer_price'] = 'Afficher les prix';
$_['entry_login_attempts'] = 'Nombre de tentatives de connexion maximum';
$_['entry_account'] = 'Termes et conditions du compte';
$_['entry_cart_weight'] = 'Afficher le poids sur la page de panier';
$_['entry_checkout_guest'] = 'Commander sans s’enregistrer';
$_['entry_checkout'] = 'Termes et conditions de la commande';
$_['entry_invoice_prefix'] = 'Préfixe de facturation';
$_['entry_order_status'] = 'Statut de la commande';
$_['entry_processing_status'] = 'Statut des commandes en cours';
$_['entry_complete_status'] = 'Statut des commandes complètes';
$_['entry_fraud_status'] = 'Statut des commandes frauduleuses';
$_['entry_api'] = 'Interface de programmation (API) de l’utilisateur';
$_['entry_stock_display'] = 'Afficher l’état du stock';
$_['entry_stock_warning'] = 'Afficher l’avertissement de rupture de stock';
$_['entry_stock_checkout'] = 'Commander du stock';
$_['entry_affiliate_group'] = 'Groupe d’affiliés';
$_['entry_affiliate_approval'] = 'Un affilié requiert une approbation';
$_['entry_affiliate_auto'] = 'Commission automatique';
$_['entry_affiliate_commission'] = 'Commission pour affilié (%)';
$_['entry_affiliate'] = 'Termes et conditions des affiliés';
$_['entry_return'] = 'Termes et conditions de retour';
$_['entry_return_status'] = 'Statut des retours';
$_['entry_captcha'] = 'CAPTCHA';
$_['entry_captcha_page'] = 'Page de CAPTCHA';
$_['entry_logo'] = 'Enseigne de la boutique';
$_['entry_icon'] = 'Icône';
$_['entry_mail_engine'] = 'Moteur de messagerie électronique';
$_['entry_mail_parameter'] = 'Paramètres de courrier électronique';
$_['entry_mail_smtp_hostname'] = 'Nom de l’hôte SMTP';
$_['entry_mail_smtp_username'] = 'Nom d’utilisateur SMTP';
$_['entry_mail_smtp_password'] = 'Mot de passe SMTP';
$_['entry_mail_smtp_port'] = 'Port SMTP';
$_['entry_mail_smtp_timeout'] = 'Pause SMTP';
$_['entry_mail_alert'] = 'Alerte par courrier électronique';
$_['entry_mail_alert_email'] = 'Adresses électroniques additionnelles';
$_['entry_secure'] = 'Utiliser SSL';
$_['entry_shared'] = 'Utiliser les sessions partagés';
$_['entry_robots'] = 'Robots';
$_['entry_seo_url'] = 'Utiliser des liens de référencement optimisés pour les moteurs de recherche';
$_['entry_file_max_size'] = 'Taille maximum de fichier';
$_['entry_file_ext_allowed'] = 'Extensions de fichier autorisées';
$_['entry_file_mime_allowed'] = 'Types MIME autorisés';
$_['entry_maintenance'] = 'Mode de maintenance';
$_['entry_password'] = 'Autoriser les mots de passe perdus';
$_['entry_encryption'] = 'Clef de chiffrement';
$_['entry_compression'] = 'Niveau de compression de sortie';
$_['entry_error_display'] = 'Afficher les erreurs';
$_['entry_error_log'] = 'Créer un journal des erreurs';
$_['entry_error_filename'] = 'Nom du fichier de journal des erreurs';
$_['entry_status'] = 'Statut';
// Help
$_['help_geocode'] = 'Veuillez saisir l’emplacement géocode de votre boutique manuellement.';
$_['help_open'] = 'Saisir les horaires d’ouverture de votre boutique.';
$_['help_comment'] = 'Ce champ est dédié aux notes spéciales que vous souhaitez indiquer au client, par exemple si votre boutique n’accepte pas les chèques.';
$_['help_location'] = 'Les différents emplacements de vos boutiques que vous voulez afficher sur le formulaire de contact.';
$_['help_currency'] = 'Changer la devise par défaut. Veuillez vider le cache de votre navigateur et réinitialiser les cookies existants.';
$_['help_currency_auto'] = 'Paramétrer votre boutique pour mettre à jour automatiquement le cour des devises tous les jours.';
$_['help_limit_admin'] = 'Détermine combien d’éléments de l’administration sont affichés par page (commandes, clients, etc.).';
$_['help_product_count'] = 'Affiche le nombre de produits à l’intérieur d’une sous-catégorie dans l’en-tête du menu des catégories. Soyez conscient que cet affichage peut causer des problèmes de performance dans le cas de boutiques avec un grand nombre de sous-catégories !';
$_['help_review'] = 'Activer et ou désactiver la saisie de nouvelle évaluation et l’affichage des évaluations existantes.';
$_['help_review_guest'] = 'Autoriser les invités à poster des évaluations.';
$_['help_voucher_min'] = 'Montant minimum pour lequel un client peut acheter un bon d’achat.';
$_['help_voucher_max'] = 'Montant maximum pour lequel un client peut acheter un bon d’achat.';
$_['help_tax_default'] = 'Utiliser l’adresse de la boutique pour calculer les taxes si personne n’est connecté. Vous pouvez choisir d’utiliser l’adresse de la boutique pour la livraison au client ou l’adresse de paiement.';
$_['help_tax_customer'] = 'Utiliser l’adresse par défaut du client quand il se connecte pour calculer les taxes. Vous pouvez choisir d’utiliser l’adresse par défaut du client pour la livraison au client ou l’adresse de paiement.';
$_['help_customer_online'] = 'Suivre l’activité des clients en ligne par le biais de la section des rapports de clients.';
$_['help_customer_activity'] = 'Suivre l’activité des clients par le biais de la section des rapports de clients.';
$_['help_customer_group'] = 'Groupe de clients par défaut.';
$_['help_customer_group_display'] = 'Afficher les groupes de clients que les nouveaux clients peuvent choisir d’utiliser quand ils s’inscrivent (tels que "revendeurs", "grossistes", etc.).';
$_['help_customer_price'] = 'Afficher les prix seulement quand le client est connecté.';
$_['help_login_attempts'] = 'Nombre maximum de tentatives de connexion avant que le compte soit bloqué pour 1 heure. Les comptes de clients et d’affiliés peuvent être débloqués sur les pages d’administration qui leur sont dédiées. Un compte d’administrateur peut être débloqué en réinitialisant le mot de passe.';
$_['help_account'] = 'Contraindre à accepter les termes et conditions avant qu’un compte ne soit créé.';
$_['help_invoice_prefix'] = 'Paramétrer le préfixe de facturation (par exemple, FA-2015-00). Les identifiants de facture commencent à 1 pour chaque préfixe unique.';
$_['help_cart_weight'] = 'Afficher le poids du panier sur la page de panier.';
$_['help_checkout_guest'] = 'Autoriser les clients à commander sans avoir créé un compte. Cette possibilité ne sera pas disponible si un produit téléchargeable est dans le panier d’achat.';
$_['help_checkout'] = 'Contraindre à accepter les termes et conditions avant de pouvoir commander.';
$_['help_order_status'] = 'Paramétrer le statut de la commande par défaut quand une commande est en cours.';
$_['help_processing_status'] = 'Paramétrer le statut que la commande d’un client doit atteindre avant que la commande débute la soustraction du stock ainsi que le remboursement des bons de réduction, des bons d’achat ou des points de fidélité.';
$_['help_complete_status'] = 'Paramétrer le statut que la commande d’un client doit atteindre avant qu’ils soient autorisés à accéder à leurs produits téléchargeables et bon d’achats.';
$_['help_fraud_status'] = 'Paramétrer le statut de la commande quand un client est suspecté d’essayer de modifier les détails du paiement de la commande ou d’utiliser un bon de réduction, un bon d’achat ou des points de fidélité qui ont déjà été utilisés.';
$_['help_api'] = 'Interface de programmation (API) de l’utilisateur par défaut que l’administrateur doit utiliser.';
$_['help_stock_display'] = 'Afficher la quantité en stock sur la page des produits.';
$_['help_stock_warning'] = 'Afficher le message de rupture de stock sur la page de panier d’achat si un produit est en rupture mais que la commande de stock est en cours. (Soyez conscient que cette mention sera toujours affichée si la commande de stock n’est pas en cours)';
$_['help_stock_checkout'] = 'Autoriser les clients à passer commande même si les produits qu’ils commandent ne sont pas en stock.';
$_['help_affiliate_approval'] = 'Approuver automatiquement tout nouvel affilié qui s’inscrit.';
$_['help_affiliate_auto'] = 'Ajouter automatiquement la commission chaque fois qu’une commande atteint le statut complété.';
$_['help_affiliate_commission'] = 'Pourcentage de la commission des affiliés par défaut.';
$_['help_affiliate'] = 'Contraindre à accepter les termes et conditions avant qu’un compte affilié puisse être créé.';
$_['help_return'] = 'Contraindre à accepter les termes et conditions avant qu’un retour ne puisse être créé.';
$_['help_return_status'] = 'Paramétrer le statut des retours par défaut quand une requête de retour est soumise.';
$_['help_captcha'] = 'CAPTCHA à utiliser pour l’enregistrement, la connexion, le formulaire de contact et les évaluations.';
$_['help_icon'] = 'L’icône doit être un fichier PNG ayant pour dimension 16px × 16px.';
$_['help_mail_engine'] = 'Choisir seulement Mail sauf si votre hébergeur a désactivé les fonctions de courrier électronique PHP.';
$_['help_mail_parameter'] = 'En cas d’utilisation de Mail, des paramètres additionnels peuvent être ajoutés ici (par exemple, -f email@storeaddress.com).';
$_['help_mail_smtp_hostname'] = 'Ajouter le préfixe <tls://> ou <ssl://> si une connexion de sécurité est requise. (par exemple : <tls://smtp.gmail.com>).';
$_['help_mail_smtp_password'] = 'Pour Gmail, vous devrez peut-être configurer un mot de passe spécifique à l’application ici : https://security.google.com/settings/security/apppasswords.';
$_['help_mail_alert'] = 'Sélectionnez pour quelles fonctionnalités vous souhaitez recevoir une alerte par courrier électronique lorsqu’un client les utilise.';
$_['help_mail_alert_email'] = 'Toutes les adresses électroniques additionnelles (séparées par des virgules) pour lesquelles vous souhaitez recevoir une alerte par courrier électronique, en plus de l’adresse principale de la boutique.';
$_['help_secure'] = 'Pour utiliser le SSL, vérifier auprès de votre hébergeur si un certificat SSL est installé et ajouter le lien SSL aux fichiers du catalogue et de la configuration d’administration.';
$_['help_shared'] = 'Essayer de partager le cookie de session entre les boutiques, ainsi le panier pourra être transféré entre différents domaines.';
$_['help_robots'] = 'Une liste de robots d’indexation (User-Agent), pour lesquels les sessions partagées ne seront pas utilisées. Utilisez des lignes séparées pour chaque agent utilisateur.';
$_['help_seo_url'] = 'Pour utiliser les liens de référencement optimisés pour les moteurs de recherche, le module de réécriture (rewrite) Apache soit être installé et vous devez renommer le fichier <htaccess.txt> en <.htaccess>.';
$_['help_file_max_size'] = 'Taille maximum des images que vous pouvez transférer par le biais du gestionnaire. À saisir en byte.';
$_['help_file_ext_allowed'] = 'Ajouter quelles extensions de fichiers sont autorisées à être transférées. Utilisez une nouvelle ligne pour chaque valeur.';
$_['help_file_mime_allowed'] = 'Ajouter quels types MIME sont autorisés à être transférés. Utilisez une nouvelle ligne pour chaque valeur.';
$_['help_maintenance'] = 'Empêche les clients de naviguer dans la boutique. Ils verront à la place un message de maintenance. Vous verrez normalement la boutique si vous vous connectez en mode administration.';
$_['help_password'] = 'Autorise les mots de passe oublié à être utiliser pour l’administration. Cette fonction sera automatiquement désactivée si le système détecte une tentative de piratage.';
$_['help_encryption'] = 'Veuillez fournir une clef secrète qui sera utilisée pour chiffrer les informations privées lors de la saisie de commande.';
$_['help_compression'] = 'GZIP pour un meilleur taux de transfert lors des requêtes des clients. Le niveau de compression doit être compris entre 0 et 9.';
// Error
$_['error_warning'] = 'Attention : veuillez vérifier attentivement les erreurs dans le formulaire !';
$_['error_permission'] = 'Attention : vous n’avez pas l’autorisation de modifier les paramètres !';
$_['error_meta_title'] = 'Attention : le titre doit contenir entre 3 et 32 caractères !';
$_['error_name'] = 'Attention : le nom de la boutique doit contenir entre 3 et 32 caractères !';
$_['error_owner'] = 'Attention : le nom du propriétaire de la boutique doit contenir entre 3 et 64 caractères !';
$_['error_address'] = 'Attention : l’adresse de la boutique doit contenir entre 10 et 256 caractères !';
$_['error_email'] = 'Attention : l’adresse électronique semble être invalide !';
$_['error_telephone'] = 'Attention : le numéro de téléphone doit contenir entre 3 et 32 caractères !';
$_['error_limit'] = 'Attention : une limite est requise !';
$_['error_login_attempts'] = 'Attention : le nombre de tentative de connexion doit être supérieur à 0 !';
$_['error_customer_group_display'] = 'Attention : vous devez inclure le groupe de clients par défaut si vous souhaitez utiliser cette fonctionnalité !';
$_['error_voucher_min'] = 'Attention : le montant minimum d’un bon d’achat est requis !';
$_['error_voucher_max'] = 'Attention : le montant maximum d’un bon d’achat est requis !';
$_['error_processing_status'] = 'Attention : vous devez choisir au moins 1 statut de commande en cours';
$_['error_complete_status'] = 'Attention : vous devez choisir au moins 1 statut de commande complète';
$_['error_log_required'] = 'Attention : le nom du fichier du journal des erreurs est requis !';
$_['error_log_invalid'] = 'Attention : le nom du fichier du journal des erreurs est invalide !';
$_['error_log_extension'] = 'Attention : l’extension du fichier du journal des erreurs doit être <.log> !';
$_['error_encryption'] = 'Attention : la clef de chiffrement doit contenir entre 32 et 1024 caractères !';
