<?php
class ControllerExtensionModuleTopbar extends Controller {
	private $error = array();

	
	public function index() {
		$this->load->language('extension/module/topbar');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');
		$this->load->model('catalog/information');
		$this->load->model('localisation/language');

		$languages = $this->model_localisation_language->getLanguages();

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$payload = $this->prepareSettingPayload($languages);

			$this->model_setting_setting->editSetting('module_topbar', $payload);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/module/topbar', 'user_token=' . $this->session->data['user_token'], true));
		}

		$data['heading_title'] = $this->language->get('heading_title');
		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_select_all'] = $this->language->get('text_select_all');
		$data['text_client_row'] = $this->language->get('text_client_row');

		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_information'] = $this->language->get('entry_information');
		$data['entry_show_catalog'] = $this->language->get('entry_show_catalog');
		$data['entry_catalog_title'] = $this->language->get('entry_catalog_title');
		$data['entry_show_language'] = $this->language->get('entry_show_language');
		$data['entry_show_currency'] = $this->language->get('entry_show_currency');
		$data['entry_show_worktime'] = $this->language->get('entry_show_worktime');
		$data['entry_worktime_title'] = $this->language->get('entry_worktime_title');
		$data['entry_worktime_items'] = $this->language->get('entry_worktime_items');
		$data['entry_show_client'] = $this->language->get('entry_show_client');
		$data['entry_client_title'] = $this->language->get('entry_client_title');
		$data['entry_client_items'] = $this->language->get('entry_client_items');

		$data['help_information'] = $this->language->get('help_information');
		$data['help_worktime_items'] = $this->language->get('help_worktime_items');
		$data['help_client_items'] = $this->language->get('help_client_items');

		$data['column_title'] = $this->language->get('column_title');
		$data['column_link'] = $this->language->get('column_link');
		$data['button_add_item'] = $this->language->get('button_add_item');
		$data['button_remove'] = $this->language->get('button_remove');
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/module/topbar', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/module/topbar', 'user_token=' . $this->session->data['user_token'], true);
		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

		if (isset($this->request->post['module_topbar_status'])) {
			$data['module_topbar_status'] = $this->request->post['module_topbar_status'];
		} else {
			$data['module_topbar_status'] = $this->config->get('module_topbar_status');
		}

		$current_setting = $this->config->get('module_topbar_setting');

		if (!is_array($current_setting)) {
			$current_setting = array();
		}

		$data['languages'] = $languages;
		$data['informations'] = $this->model_catalog_information->getInformations();

		$data['module_topbar_information_ids'] = isset($this->request->post['module_topbar_information_ids']) ? $this->request->post['module_topbar_information_ids'] : ($current_setting['information_ids'] ?? array());
		$data['module_topbar_show_catalog'] = isset($this->request->post['module_topbar_show_catalog']) ? $this->request->post['module_topbar_show_catalog'] : (!empty($current_setting['show_catalog']));
		$data['module_topbar_show_language'] = isset($this->request->post['module_topbar_show_language']) ? $this->request->post['module_topbar_show_language'] : (!empty($current_setting['show_language']));
		$data['module_topbar_show_currency'] = isset($this->request->post['module_topbar_show_currency']) ? $this->request->post['module_topbar_show_currency'] : (!empty($current_setting['show_currency']));
		$data['module_topbar_show_worktime'] = isset($this->request->post['module_topbar_show_worktime']) ? $this->request->post['module_topbar_show_worktime'] : (!empty($current_setting['show_worktime']));
		$data['module_topbar_show_client'] = isset($this->request->post['module_topbar_show_client']) ? $this->request->post['module_topbar_show_client'] : (!empty($current_setting['show_client']));

		$data['module_topbar_catalog_title'] = array();
		$data['module_topbar_worktime_title'] = array();
		$data['module_topbar_worktime_items'] = array();
		$data['module_topbar_client_title'] = array();
		$data['module_topbar_client_items'] = array();
		$data['module_topbar_client_next'] = array();

		foreach ($languages as $language) {
			$language_id = $language['language_id'];

			if (isset($this->request->post['module_topbar_catalog_title'][$language_id])) {
				$data['module_topbar_catalog_title'][$language_id] = $this->request->post['module_topbar_catalog_title'][$language_id];
			} else {
				$data['module_topbar_catalog_title'][$language_id] = $current_setting['catalog_title'][$language_id] ?? '';
			}

			if (isset($this->request->post['module_topbar_worktime_title'][$language_id])) {
				$data['module_topbar_worktime_title'][$language_id] = $this->request->post['module_topbar_worktime_title'][$language_id];
			} else {
				$data['module_topbar_worktime_title'][$language_id] = $current_setting['worktime_title'][$language_id] ?? '';
			}

			if (isset($this->request->post['module_topbar_worktime_items'][$language_id])) {
				$data['module_topbar_worktime_items'][$language_id] = $this->request->post['module_topbar_worktime_items'][$language_id];
			} else {
				$items = $current_setting['worktime_items'][$language_id] ?? array();
				$data['module_topbar_worktime_items'][$language_id] = implode("\n", $items);
			}

			if (isset($this->request->post['module_topbar_client_title'][$language_id])) {
				$data['module_topbar_client_title'][$language_id] = $this->request->post['module_topbar_client_title'][$language_id];
			} else {
				$data['module_topbar_client_title'][$language_id] = $current_setting['client_title'][$language_id] ?? '';
			}

			if (isset($this->request->post['module_topbar_client_items'][$language_id])) {
				$data['module_topbar_client_items'][$language_id] = $this->request->post['module_topbar_client_items'][$language_id];
			} else {
				$data['module_topbar_client_items'][$language_id] = $current_setting['client_items'][$language_id] ?? array();
			}

			$data['module_topbar_client_next'][$language_id] = count($data['module_topbar_client_items'][$language_id]);
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/topbar', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/topbar')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}

	private function prepareSettingPayload($languages) {
		$status = isset($this->request->post['module_topbar_status']) ? (int)$this->request->post['module_topbar_status'] : 0;

		$setting = array();
		$setting['information_ids'] = array();

		if (!empty($this->request->post['module_topbar_information_ids']) && is_array($this->request->post['module_topbar_information_ids'])) {
			foreach ($this->request->post['module_topbar_information_ids'] as $information_id) {
				$setting['information_ids'][] = (int)$information_id;
			}
		}

		$setting['show_catalog'] = !empty($this->request->post['module_topbar_show_catalog']);
		$setting['catalog_title'] = $this->request->post['module_topbar_catalog_title'] ?? array();
		$setting['show_language'] = !empty($this->request->post['module_topbar_show_language']);
		$setting['show_currency'] = !empty($this->request->post['module_topbar_show_currency']);
		$setting['show_worktime'] = !empty($this->request->post['module_topbar_show_worktime']);
		$setting['worktime_title'] = $this->request->post['module_topbar_worktime_title'] ?? array();
		$setting['show_client'] = !empty($this->request->post['module_topbar_show_client']);
		$setting['client_title'] = $this->request->post['module_topbar_client_title'] ?? array();

		$setting['worktime_items'] = array();
		foreach ($languages as $language) {
			$language_id = $language['language_id'];
			$list = array();

			if (isset($this->request->post['module_topbar_worktime_items'][$language_id])) {
				$lines = preg_split("/\r\n|\r|\n/", $this->request->post['module_topbar_worktime_items'][$language_id]);

				foreach ($lines as $line) {
					$line = trim($line);

					if ($line !== '') {
						$list[] = $line;
					}
				}
			}

			$setting['worktime_items'][$language_id] = $list;
		}

		$setting['client_items'] = array();

		if (!empty($this->request->post['module_topbar_client_items']) && is_array($this->request->post['module_topbar_client_items'])) {
			foreach ($this->request->post['module_topbar_client_items'] as $language_id => $entries) {
				$setting['client_items'][$language_id] = array();

				foreach ($entries as $entry) {
					$title = isset($entry['title']) ? trim($entry['title']) : '';
					$href = isset($entry['href']) ? trim($entry['href']) : '';

					if ($title === '' && $href === '') {
						continue;
					}

					$setting['client_items'][$language_id][] = array(
						'title' => $title,
						'href'  => $href
					);
				}
			}
		}

		return array(
			'module_topbar_status'  => $status,
			'module_topbar_setting' => $setting
		);
	}
}
