<?php
class ControllerExtensionModuleCategoryCards extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/module/category_cards');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/module');
		$this->load->model('catalog/category');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			if (!isset($this->request->get['module_id'])) {
				$this->model_setting_module->addModule('category_cards', $this->request->post);
			} else {
				$this->model_setting_module->editModule($this->request->get['module_id'], $this->request->post);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));
		}

		$data['error_warning'] = !empty($this->error['warning']) ? $this->error['warning'] : '';
		$data['error_name'] = !empty($this->error['name']) ? $this->error['name'] : '';
		$data['error_categories'] = !empty($this->error['categories']) ? $this->error['categories'] : '';
		$data['error_width'] = !empty($this->error['width']) ? $this->error['width'] : '';
		$data['error_height'] = !empty($this->error['height']) ? $this->error['height'] : '';

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		);

		$module_id = isset($this->request->get['module_id']) ? $this->request->get['module_id'] : 0;

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/module/category_cards', 'user_token=' . $this->session->data['user_token'] . '&module_id=' . $module_id, true)
		);

		$data['action'] = $this->url->link('extension/module/category_cards', 'user_token=' . $this->session->data['user_token'] . (!empty($module_id) ? '&module_id=' . $module_id : ''), true);
		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

		$module_info = array();

		if ($module_id && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$module_info = $this->model_setting_module->getModule($module_id);
		}

		if (isset($this->request->post['name'])) {
			$data['name'] = $this->request->post['name'];
		} elseif (!empty($module_info)) {
			$data['name'] = $module_info['name'];
		} else {
			$data['name'] = '';
		}

		if (isset($this->request->post['title'])) {
			$data['title'] = $this->request->post['title'];
		} elseif (!empty($module_info) && isset($module_info['title'])) {
			$data['title'] = $module_info['title'];
		} else {
			$data['title'] = $this->language->get('default_title');
		}

		if (isset($this->request->post['category_ids'])) {
			$category_ids = $this->request->post['category_ids'];
		} elseif (!empty($module_info['category_ids'])) {
			$category_ids = $module_info['category_ids'];
		} else {
			$category_ids = array();
		}

		$data['categories'] = array();

		foreach ($category_ids as $category_id) {
			$category_info = $this->model_catalog_category->getCategory($category_id);

			if ($category_info) {
				$data['categories'][] = array(
					'category_id' => $category_info['category_id'],
					'name'        => $category_info['name']
				);
			}
		}

		if (isset($this->request->post['width'])) {
			$data['width'] = $this->request->post['width'];
		} elseif (!empty($module_info)) {
			$data['width'] = $module_info['width'];
		} else {
			$data['width'] = 600;
		}

		if (isset($this->request->post['height'])) {
			$data['height'] = $this->request->post['height'];
		} elseif (!empty($module_info)) {
			$data['height'] = $module_info['height'];
		} else {
			$data['height'] = 350;
		}

		if (isset($this->request->post['status'])) {
			$data['status'] = $this->request->post['status'];
		} elseif (!empty($module_info)) {
			$data['status'] = $module_info['status'];
		} else {
			$data['status'] = 0;
		}

		$data['user_token'] = $this->session->data['user_token'];

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/category_cards', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/category_cards')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 64)) {
			$this->error['name'] = $this->language->get('error_name');
		}

		if (empty($this->request->post['category_ids'])) {
			$this->error['categories'] = $this->language->get('error_categories');
		}

		if (empty($this->request->post['width'])) {
			$this->error['width'] = $this->language->get('error_width');
		}

		if (empty($this->request->post['height'])) {
			$this->error['height'] = $this->language->get('error_height');
		}

		return !$this->error;
	}
}
