<?php
class ControllerExtensionModuleAboutBlock extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/module/about_block');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/module');
		$this->load->model('localisation/language');
		$this->load->model('tool/image');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			if (!isset($this->request->get['module_id'])) {
				$this->model_setting_module->addModule('about_block', $this->request->post);
			} else {
				$this->model_setting_module->editModule($this->request->get['module_id'], $this->request->post);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));
		}

		
		$data['heading_title'] = $this->language->get('heading_title');
		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');

		$data['entry_name'] = $this->language->get('entry_name');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_title'] = $this->language->get('entry_title');
		$data['entry_subtitle'] = $this->language->get('entry_subtitle');
		$data['entry_description'] = $this->language->get('entry_description');
		$data['entry_button_text'] = $this->language->get('entry_button_text');
		$data['entry_button_link'] = $this->language->get('entry_button_link');
		$data['entry_image'] = $this->language->get('entry_image');
		$data['help_description'] = $this->language->get('help_description');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['name'])) {
			$data['error_name'] = $this->error['name'];
		} else {
			$data['error_name'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		);

		if (!isset($this->request->get['module_id'])) {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('extension/module/about_block', 'user_token=' . $this->session->data['user_token'], true)
			);

			$data['action'] = $this->url->link('extension/module/about_block', 'user_token=' . $this->session->data['user_token'], true);
		} else {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('extension/module/about_block', 'user_token=' . $this->session->data['user_token'] . '&module_id=' . $this->request->get['module_id'], true)
			);

			$data['action'] = $this->url->link('extension/module/about_block', 'user_token=' . $this->session->data['user_token'] . '&module_id=' . $this->request->get['module_id'], true);
		}

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

		if (isset($this->request->get['module_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$module_info = $this->model_setting_module->getModule($this->request->get['module_id']);
		} else {
			$module_info = array();
		}

		$data['user_token'] = $this->session->data['user_token'];
		$data['languages'] = $this->model_localisation_language->getLanguages();

		if (isset($this->request->post['name'])) {
			$data['name'] = $this->request->post['name'];
		} elseif (!empty($module_info)) {
			$data['name'] = $module_info['name'];
		} else {
			$data['name'] = '';
		}

		if (isset($this->request->post['status'])) {
			$data['status'] = $this->request->post['status'];
		} elseif (!empty($module_info)) {
			$data['status'] = $module_info['status'];
		} else {
			$data['status'] = 1;
		}

		foreach ($data['languages'] as $language) {
			$language_id = $language['language_id'];

			$data['module_about_block_title'][$language_id] = isset($this->request->post['title'][$language_id]) ? $this->request->post['title'][$language_id] : ($module_info['title'][$language_id] ?? '');
			$data['module_about_block_subtitle'][$language_id] = isset($this->request->post['subtitle'][$language_id]) ? $this->request->post['subtitle'][$language_id] : ($module_info['subtitle'][$language_id] ?? '');
			$data['module_about_block_description'][$language_id] = isset($this->request->post['description'][$language_id]) ? $this->request->post['description'][$language_id] : ($module_info['description'][$language_id] ?? '');
			$data['module_about_block_button_text'][$language_id] = isset($this->request->post['button_text'][$language_id]) ? $this->request->post['button_text'][$language_id] : ($module_info['button_text'][$language_id] ?? '');
		}

		if (isset($this->request->post['button_link'])) {
			$data['button_link'] = $this->request->post['button_link'];
		} elseif (!empty($module_info)) {
			$data['button_link'] = $module_info['button_link'] ?? '';
		} else {
			$data['button_link'] = '';
		}

		if (isset($this->request->post['image'])) {
			$data['image'] = $this->request->post['image'];
		} elseif (!empty($module_info)) {
			$data['image'] = $module_info['image'] ?? '';
		} else {
			$data['image'] = '';
		}

		if ($data['image'] && is_file(DIR_IMAGE . $data['image'])) {
			$data['thumb'] = $this->model_tool_image->resize($data['image'], 200, 200);
		} else {
			$data['thumb'] = $this->model_tool_image->resize('no_image.png', 200, 200);
		}

		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 200, 200);

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/about_block', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/about_block')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 64)) {
			$this->error['name'] = $this->language->get('error_name');
		}

		return !$this->error;
	}
}
